package org.msh.tb.bd.tbforms.query.tb11;

import org.msh.tb.entities.enums.CaseState;
import org.msh.tb.entities.enums.Gender;

/**
 * Stores data element ids for columns of Block 1 and Block 3
 */
public enum TB11Column {
    TOTAL_REGISTERED(true, null, null),
    SUCCESSFULLY_TREATED_UNTIL_14(false, "WEyEj8rTeGr", "PPrtEWtYPSz"),
    SUCCESSFULLY_TREATED_AFTER_14(false, "QfYYdSpagK7", "Hckzo0admaw"),
    DIED(false, "OGc8rYCT0T6", "w6ZXJid8Uiq"),
    FAILED(false, "prFvasWs553", "bzoSsuYbp0v"),
    LOSS_FOLLOW_UP(false, "k5HBnyIebsv", "BkTfho9Rxwf"),
    TRANSFERRED_OUT(false, "R69kkIyVtmW", "ILwtJmUlwPQ"),
    NOT_EVALUATED(false, "fnHCpHMtuem", "Axa65I93B9L"),
    GRAND_TOTAL(true, null, null);

    boolean hasTotal;
    String maleCocDHIS2Id;
    String femaleCocDHIS2Id;

    TB11Column(boolean hasTotal, String maleCocDHIS2Id, String femaleCocDHIS2Id) {
        this.hasTotal = hasTotal;
        this.maleCocDHIS2Id = maleCocDHIS2Id;
        this.femaleCocDHIS2Id = femaleCocDHIS2Id;
    }

    public static TB11Column getStateAsColumn(CaseState caseState) {
        if (CaseState.CURED.equals(caseState) || CaseState.TREATMENT_COMPLETED.equals(caseState)) {
            throw new RuntimeException("Cured or treat completed should not be passaed as param");
        }

        switch(caseState) {
            case DIED:
            case DIED_NOTTB:
                return TB11Column.DIED;
            case FAILED:
                return TB11Column.FAILED;
            case DEFAULTED:
                return TB11Column.LOSS_FOLLOW_UP;
            case TRANSFERRED_OUT:
                return TB11Column.TRANSFERRED_OUT;
            case NOT_EVALUATED:
            default:
                return TB11Column.NOT_EVALUATED;
        }
    }

    public static String getDHIS2CocId(CaseState c, Gender g) {
        TB11Column column = TB11Column.getStateAsColumn(c);

        switch(g) {
            case MALE:
                return column.getMaleCocDHIS2Id();
            case FEMALE:
                return column.getFemaleCocDHIS2Id();
        }

        throw new RuntimeException("TB12Column Outcome: coc id not found");
    }

    public String getDHIS2CocId(Gender g) {
        switch(g) {
            case MALE:
                return this.getMaleCocDHIS2Id();
            case FEMALE:
                return this.getFemaleCocDHIS2Id();
        }

        throw new RuntimeException("TB12Column Outcome: coc id not found");
    }

    public String getMaleCocDHIS2Id() {
        return maleCocDHIS2Id;
    }

    public void setMaleCocDHIS2Id(String maleCocDHIS2Id) {
        this.maleCocDHIS2Id = maleCocDHIS2Id;
    }

    public String getFemaleCocDHIS2Id() {
        return femaleCocDHIS2Id;
    }

    public void setFemaleCocDHIS2Id(String femaleCocDHIS2Id) {
        this.femaleCocDHIS2Id = femaleCocDHIS2Id;
    }

    public boolean isHasTotal() {
        return hasTotal;
    }
}
